import { StyleSheet } from "react-native";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";

export const productDetailsStyle = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
    },
    ScrollViewWrap: {
        backgroundColor: "#FFFFFF",
    },
    header: {
        flexDirection: "row",
        position: "absolute",
        right: dpr(20),
        top: dpr(18),
    },
    quantityCont: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        width: (dpr("wf") - dpr(20) - 30) / 2,
    },
    quantity: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(24),
        color: "#2C2C2C",
        marginHorizontal: dpr(15),
        width: dpr(35),
        textAlign: "center",
    },
    quantityIcon: {
        height: dpr(35),
        width: dpr(35),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    addToCartContainer: (disableBtn, width) => ({
        height: dpr(45),
        width: dpr(185),
        borderRadius: dpr(6),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
        width: width,
        backgroundColor: disableBtn == false ? "#FCCA19" : "#F3F3F3",
    }),
    addToCartContAffiliate: {
        height: dpr(45),
        width: dpr("wf") - dpr(12 * 2),
        borderRadius: dpr(6),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
        backgroundColor: "#FCCA19",
    },
    addToCartContAffiliateColor: (url) => ({
        backgroundColor: url ? "#FCCA19" : "#F3F3F3",
    }),
    addToCart: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    cartBtnText: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginLeft: dpr(7),
    },
    wishlistContainer: {
        height: dpr(35),
        width: dpr(35),
        marginRight: dpr(12),
        backgroundColor: "#F9E8E8",
        borderRadius: 50,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    relatedItemWrap: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        alignItems: 'flex-start'
    },
    sellerItemWrap: {
        marginTop: dpr(20),
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
    },
});
